package AutoComplete;

import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.lang.Delegate;

/**
 * This class is a visual component. The entry point for class execution
 * is the constructor.
 */
public class autoList extends UserControl
{
	/**
	 * Occurs whenever the text inside the edit box is changed
	 */
	EventHandler m_TextChanged;
	/**
	 * Associated trie for autocomplete
	 */
	private trie m_WordsTrie;
	private String lastChanged = "";
	private boolean inChangeText = false;
	
	/**
	 * Occurs whenever the text inside the edit box is changed
	 */
	public void addOnTextChanged(EventHandler value)
	{
		m_TextChanged = (EventHandler)Delegate.combine(m_TextChanged, value);
	}

	public autoList()
	{
		super();

		// Required for Visual J++ Form Designer support
		//
		initForm();

		// TODO: Add any constructor code after initForm call
	}

	private void edit1_textChanged(Object source, Event e)
	{
		if (inChangeText == true) return;
		inChangeText = true;
		String temp = edit1.getText();
		if(!temp.equals(lastChanged)) {
			String ending = m_WordsTrie.getEnd(temp);
			if (ending != null) {
				edit1.setSelectedText(ending);
				edit1.setSelectionStart(temp.length());
			}
		}
		lastChanged = temp;
		inChangeText = false;
		m_TextChanged.invoke(source,e);
	}

	/**
	 * The text contained in the control
	 */
	public String getText()
	{
		// TODO: Add your own implementation.
		if(edit1 == null) return "";
		return edit1.getText();
	}

	/**
	 * Associated trie for autocomplete
	 */
	public trie getWordsTrie()
	{
		// TODO: Add your own implementation.
		return m_WordsTrie;
	}

	/**
	 * Occurs whenever the text inside the edit box is changed
	 */
	protected void onTextChanged(Event event)
	{
		if (m_TextChanged != null) m_TextChanged.invoke(this, event);
	}

	/**
	 * Occurs whenever the text inside the edit box is changed
	 */
	public void removeOnTextChanged(EventHandler value)
	{
		m_TextChanged = (EventHandler)Delegate.remove(m_TextChanged, value);
	}

	/**
	 * The text contained in the control
	 */
	public void setText(String value)
	{
		// TODO: Add your own implementation.
		edit1.setText(value);
	}

	/**
	 * Associated trie for autocomplete
	 */
	public void setWordsTrie(trie value)
	{
		// TODO: Add your own implementation.
		m_WordsTrie = value;
	}

	private void autoList_keyPress(Object source, KeyPressEvent e) {
		if(e.keyChar == Key.BACK) {
			e.handled = true;
			inChangeText = true;
			edit1.setSelectedText("");
			String temp = edit1.getText();
			if(!temp.equals("")) {
				temp = temp.substring(0, temp.length()-1);
				edit1.setText(temp);
				edit1.setSelectionStart(temp.length());
				if(m_TextChanged != null) m_TextChanged.invoke(this,e);
			}
			inChangeText = false;
		}
	}

	/**
	 * NOTE: The following code is required by the Visual J++ form
	 * designer.  It can be modified using the form editor.  Do not
	 * modify it using the code editor.
	 */
	Container components = new Container();
	Edit edit1 = new Edit();

	private void initForm() { 
		this.setForeColor(Color.ACTIVEBORDER);
		this.setSize(new Point(148, 19));
		this.setText("");

		edit1.setDock(ControlDock.FILL);
		edit1.setForeColor(Color.CONTROLDARKDARK);
		edit1.setSize(new Point(148, 20));
		edit1.setTabIndex(0);
		edit1.setText("");
		edit1.addOnKeyPress(new KeyPressEventHandler(this.autoList_keyPress));
		edit1.addOnTextChanged(new EventHandler(this.edit1_textChanged));

		this.setNewControls(new Control[] {
							edit1});
	}

	
	
	public static class ClassInfo extends UserControl.ClassInfo
	{
		// TODO: Add your property and event infos here
		
		public static final PropertyInfo text = new PropertyInfo(
			autoList.class, "text", String.class,
			CategoryAttribute.Appearance,
			new DescriptionAttribute("The text contained in the control"));
		public static final EventInfo textChanged = new EventInfo(
			autoList.class, "textChanged", EventHandler.class,
			new CategoryAttribute("Behavior"),
			new DescriptionAttribute("Occurs whenever the text inside the edit box is changed"));
		public void getProperties(IProperties props) {
			super.getProperties(props);
			props.add(text);
		}
		
		public void getEvents(IEvents events) {
			super.getEvents(events);
			events.add(textChanged);
		}
	}
}
